simulate_data_scenario1 <- function(n, scale = 1, shape = 1, beta, cens = 0.5) {
  
  
  # seed for later (to ensure different values)
  seed <- round(runif(1,0,10000))
  # Baseline data definitions (formula = R expression for mean, dist = distribution)
  def <- defData(varname = "trt", formula = 0.5, dist = "binary") # treatment variable
  def <- defData(def, varname = "X1",  formula = 0.5, dist = "binary") # binary variable
  def <- defData(def, varname = "X2",  formula = 0.5, dist = "binary") # binary variable
  def <- defData(def, varname = "X3",  formula = 0.5, dist = "binary") # binary variable
  def <- defData(def, varname = "X4",  formula = 0.5, dist = "binary") # binary variable
  def <- defData(def, varname = "X5",  formula = 0.5, dist = "binary") # binary variable
  def <- defData(def, varname = "z1",  formula = 0, dist = "normal", variance = 1) # noise variable 
  def <- defData(def, varname = "z2",  formula = 0, dist = "normal", variance = 1) # noise variable 
  def <- defData(def, varname = "z3",  formula = 0, dist = "normal", variance = 1) # noise variable 
  def <- defData(def, varname = "z4",  formula = 0, dist = "normal", variance = 1) # noise variable 
  def <- defData(def, varname = "z5",  formula = 0, dist = "normal", variance = 1) # noise variable 
  
  # generate data
  d <- genData(n, def) 
  
  # Survival data definitions
  # Weibull model
  # T = (-(log(U)*scale)/exp(beta*x))^shape
  # U ~ Unif(0,1)
  # beta = coefficients from Cox model
  set.seed(1234)

  
  mu            <- rep(0,5)
  rmat          <- matrix(rnorm(5^2), 5, 5) # for calculation of correlation among covariates
  cov_mat       <- rmat%*%t(rmat) # for calculation of correlation among covariates
  corr_mat      <- cov_mat/sqrt(diag(cov_mat)%*%t(diag(cov_mat))) # correlation among covariates

  set.seed(seed)
  

  
  dtAdd <- addCorData(d, "id", mu = mu, corMatrix = corr_mat, sigma = 1) %>%
    set_colnames(c("id", "trt", paste0("X", 1:5), paste0("z", 1:5), paste0("x", 1:5))) %>%
    dplyr::select(c(1,13:17,3:7,2,8:12))
  
  #dtAdd <- addCorData(d, "id", mu = mu, rho = 0, sigma = 1) %>%
  #  set_colnames(c("id", "trt", paste0("X", 1:5), paste0("z", 1:5), paste0("x", 1:5))) %>%
  #  dplyr::select(c(1,13:17,3:7,2,8:12))
  
  #set.seed(1409)
  # formula
  formula <- paste0(beta, "*", c(paste0("x", 1:5), paste0("X", 1:5), "trt"), collapse = " + ")
  
  sdef <- defSurv(varname = "survTime", formula = formula, # beta = 1.5
                  scale = scale, # scale and shape vary by group membership
                  shape = shape) # for survival times
  
  scale_cens <- case_when(cens == 0.5 ~ 4,
                          cens == 0.75 ~ 0.85,
                          cens == 0.25 ~ 10)
  
  shape_cens <- case_when(cens == 0.5 ~ 1,
                          cens == 0.75 ~ 1,
                          cens == 0.25 ~ 1.6)
  
  sdef <- defSurv(sdef, varname = "censorTime", scale = scale_cens, shape = shape_cens) # for censoring times
  
  
  
  data <- genSurv(dtAdd, sdef, timeName = "time", censorName = "censorTime", eventName = "status", keepEvents = TRUE) %>%
    dplyr::select(-c("censorTime", "survTime", "type")) %>%
    as.data.frame()
  
  round(table(data$status)/n, 2)
  
  ggplot(data, aes(x = time, fill = factor(status), group = status)) +
    geom_histogram()
  
  return(data)
}


simulate_data_scenario2 <- function(n, scale = 1, shape = 1, beta, interactions, cens = 0.5) {
  
  # seed for later (to ensure different values)
  seed <- round(runif(1,0,10000))
  # Baseline data definitions (formula = R expression for mean, dist = distribution)
  def <- defData(varname = "trt", formula = 0.5, dist = "binary") # treatment variable
  def <- defData(def, varname = "X1",  formula = 0.5, dist = "binary") # binary variable
  def <- defData(def, varname = "X2",  formula = 0.5, dist = "binary") # binary variable
  def <- defData(def, varname = "X3",  formula = 0.5, dist = "binary") # binary variable
  def <- defData(def, varname = "X4",  formula = 0.5, dist = "binary") # binary variable
  def <- defData(def, varname = "X5",  formula = 0.5, dist = "binary") # binary variable
  def <- defData(def, varname = "z1",  formula = 0, dist = "normal", variance = 1) # noise variable 
  def <- defData(def, varname = "z2",  formula = 0, dist = "normal", variance = 1) # noise variable 
  def <- defData(def, varname = "z3",  formula = 0, dist = "normal", variance = 1) # noise variable 
  def <- defData(def, varname = "z4",  formula = 0, dist = "normal", variance = 1) # noise variable 
  def <- defData(def, varname = "z5",  formula = 0, dist = "normal", variance = 1) # noise variable 
  
  # generate data
  d <- genData(n, def) 
  
  # Survival data definitions
  # Weibull model
  # T = (-(log(U)*scale)/exp(beta*x))^shape
  # U ~ Unif(0,1)
  # beta = coefficients from Cox model
  set.seed(1234)
  mu            <- rep(0,5)
  rmat          <- matrix(rnorm(5^2), 5, 5) # for calculation of correlation among covariates
  cov_mat       <- rmat%*%t(rmat) # for calculation of correlation among covariates
  corr_mat      <- cov_mat/sqrt(diag(cov_mat)%*%t(diag(cov_mat))) # correlation among covariates
  
  set.seed(seed)
  
  
  
  dtAdd <- addCorData(d, "id", mu = mu, corMatrix = corr_mat, sigma = 1) %>%
    set_colnames(c("id", "trt", paste0("X", 1:5), paste0("z", 1:5), paste0("x", 1:5))) %>%
    dplyr::select(c(1,13:17,3:7,2,8:12))
  
  #dtAdd <- addCorData(d, "id", mu = mu, rho = 0, sigma = 1) %>%
  #  set_colnames(c("id", "trt", paste0("X", 1:5), paste0("z", 1:5), paste0("x", 1:5))) %>%
  #  dplyr::select(c(1,13:17,3:7,2,8:12))

  
  # formula
  formula <- paste0(beta, "*", c(paste0("x", 1:5), paste0("X", 1:5), "trt", interactions), collapse = " + ")
  
  sdef <- defSurv(varname = "survTime", formula = formula, # beta = 1.5
                  scale = scale, # scale and shape vary by group membership
                  shape = shape) # for survival times
  
  scale_cens <- case_when(cens == 0.5 ~ 3,
                          cens == 0.75 ~ 0.5,
                          cens == 0.25 ~ 10)
  
  shape_cens <- case_when(cens == 0.5 ~ 1,
                          cens == 0.75 ~ 1,
                          cens == 0.25 ~ 1.7)
  
  sdef <- defSurv(sdef, varname = "censorTime", scale = scale_cens, shape = shape_cens) # for censoring times
  
  
  
  data <- genSurv(dtAdd, sdef, timeName = "time", censorName = "censorTime", eventName = "status", keepEvents = TRUE) %>%
    dplyr::select(-c("censorTime", "survTime", "type")) %>%
    as.data.frame()
  
  round(table(data$status)/n, 2)
  
  ggplot(data, aes(x = time, fill = factor(status), group = status)) +
    geom_histogram()
  
  #return(data)
  
  round(table(data$status)/n, 2)
  
  return(data)
}

simulate_data_scenario3 <- function(n, scale = 1, shape = 1, beta_1, beta_2, transition, cens = 0.5) {
  
  # seed for later (to ensure different values)
  seed <- round(runif(1,0,10000))
  # Baseline data definitions (formula = R expression for mean, dist = distribution)
  def <- defData(varname = "trt", formula = 0.5, dist = "binary") # treatment variable
  def <- defData(def, varname = "X1",  formula = 0.5, dist = "binary") # binary variable
  def <- defData(def, varname = "X2",  formula = 0.5, dist = "binary") # binary variable
  def <- defData(def, varname = "X3",  formula = 0.5, dist = "binary") # binary variable
  def <- defData(def, varname = "X4",  formula = 0.5, dist = "binary") # binary variable
  def <- defData(def, varname = "X5",  formula = 0.5, dist = "binary") # binary variable
  def <- defData(def, varname = "z1",  formula = 0, dist = "normal", variance = 1) # noise variable 
  def <- defData(def, varname = "z2",  formula = 0, dist = "normal", variance = 1) # noise variable 
  def <- defData(def, varname = "z3",  formula = 0, dist = "normal", variance = 1) # noise variable 
  def <- defData(def, varname = "z4",  formula = 0, dist = "normal", variance = 1) # noise variable 
  def <- defData(def, varname = "z5",  formula = 0, dist = "normal", variance = 1) # noise variable 
  
  # generate data
  d <- genData(n, def) 
  
  # Survival data definitions
  # Weibull model
  # T = (-(log(U)*scale)/exp(beta*x))^shape
  # U ~ Unif(0,1)
  # beta = coefficients from Cox model
  set.seed(1234)
  
  
  mu            <- rep(0,5)
  rmat          <- matrix(rnorm(5^2), 5, 5) # for calculation of correlation among covariates
  cov_mat       <- rmat%*%t(rmat) # for calculation of correlation among covariates
  corr_mat      <- cov_mat/sqrt(diag(cov_mat)%*%t(diag(cov_mat))) # correlation among covariates
  
  set.seed(seed)
  
  
  
  dtAdd <- addCorData(d, "id", mu = mu, corMatrix = corr_mat, sigma = 1) %>%
    set_colnames(c("id", "trt", paste0("X", 1:5), paste0("z", 1:5), paste0("x", 1:5))) %>%
    dplyr::select(c(1,13:17,3:7,2,8:12))
  
  #dtAdd <- addCorData(d, "id", mu = mu, rho = 0, sigma = 1) %>%
  #  set_colnames(c("id", "trt", paste0("X", 1:5), paste0("z", 1:5), paste0("x", 1:5))) %>%
  #  dplyr::select(c(1,13:17,3:7,2,8:12))
  
  
  #set.seed(1409)
  # formula
  formula1 <- paste0(beta_1, "*", c(paste0("x", 1:5), paste0("X", 1:5), "trt"), collapse = " + ")
  formula2 <- paste0(beta_2, "*", c(paste0("x", 1:5), paste0("X", 1:5), "trt"), collapse = " + ")
  
  
  sdef <- defSurv(varname = "survTime", formula = formula1, # beta = 1.5
                  scale = scale, # scale and shape vary by group membership
                  shape = shape, transition = 0) # for survival times
  sdef <- defSurv(sdef, varname = "survTime", formula = formula2, # beta = 1.5
                  scale = scale, # scale and shape vary by group membership
                  shape = shape, transition = transition) # for survival times
  
  
  scale_cens <- case_when(cens == 0.5 ~ 1.6,
                          cens == 0.75 ~ 0.6,
                          cens == 0.25 ~ 10)
  
  shape_cens <- case_when(cens == 0.5 ~ 1,
                          cens == 0.75 ~ 1,
                          cens == 0.25 ~ 0.5)
  
  sdef <- defSurv(sdef, varname = "censorTime", scale = scale_cens, shape = shape_cens) # for censoring times
  

  
  data <- genSurv(dtAdd, sdef, timeName = "time", censorName = "censorTime", eventName = "status", keepEvents = TRUE) %>%
    dplyr::select(-c("censorTime", "survTime", "type")) %>%
    as.data.frame()
  
  round(table(data$status)/n, 2)
  
  ggplot(data, aes(x = time, fill = factor(status), group = status)) +
    geom_histogram()
  
  return(data)
}

simulate_data_scenario4 <- function(n, scale = 1, shape = 1, beta_1, beta_2, transition, interactions, cens = 0.5) {
  
  # seed for later (to ensure different values)
  seed <- round(runif(1,0,10000))
  # Baseline data definitions (formula = R expression for mean, dist = distribution)
  def <- defData(varname = "trt", formula = 0.5, dist = "binary") # treatment variable
  def <- defData(def, varname = "X1",  formula = 0.5, dist = "binary") # binary variable
  def <- defData(def, varname = "X2",  formula = 0.5, dist = "binary") # binary variable
  def <- defData(def, varname = "X3",  formula = 0.5, dist = "binary") # binary variable
  def <- defData(def, varname = "X4",  formula = 0.5, dist = "binary") # binary variable
  def <- defData(def, varname = "X5",  formula = 0.5, dist = "binary") # binary variable
  def <- defData(def, varname = "z1",  formula = 0, dist = "normal", variance = 1) # noise variable 
  def <- defData(def, varname = "z2",  formula = 0, dist = "normal", variance = 1) # noise variable 
  def <- defData(def, varname = "z3",  formula = 0, dist = "normal", variance = 1) # noise variable 
  def <- defData(def, varname = "z4",  formula = 0, dist = "normal", variance = 1) # noise variable 
  def <- defData(def, varname = "z5",  formula = 0, dist = "normal", variance = 1) # noise variable 
  
  # generate data
  d <- genData(n, def) 
  
  # Survival data definitions
  # Weibull model
  # T = (-(log(U)*scale)/exp(beta*x))^shape
  # U ~ Unif(0,1)
  # beta = coefficients from Cox model
  set.seed(1234)
  mu            <- rep(0,5)
  rmat          <- matrix(rnorm(5^2), 5, 5) # for calculation of correlation among covariates
  cov_mat       <- rmat%*%t(rmat) # for calculation of correlation among covariates
  corr_mat      <- cov_mat/sqrt(diag(cov_mat)%*%t(diag(cov_mat))) # correlation among covariates
  
  set.seed(seed)
  
  
  
  dtAdd <- addCorData(d, "id", mu = mu, corMatrix = corr_mat, sigma = 1) %>%
    set_colnames(c("id", "trt", paste0("X", 1:5), paste0("z", 1:5), paste0("x", 1:5))) %>%
    dplyr::select(c(1,13:17,3:7,2,8:12))
  
  #dtAdd <- addCorData(d, "id", mu = mu, rho = 0, sigma = 1) %>%
  #  set_colnames(c("id", "trt", paste0("X", 1:5), paste0("z", 1:5), paste0("x", 1:5))) %>%
  #  dplyr::select(c(1,13:17,3:7,2,8:12))
  
  

  # formula
  formula1 <- paste0(beta_1, "*", c(paste0("x", 1:5), paste0("X", 1:5), "trt", interactions), collapse = " + ")
  formula2 <- paste0(beta_2, "*", c(paste0("x", 1:5), paste0("X", 1:5), "trt", interactions), collapse = " + ")
  
  
  sdef <- defSurv(varname = "survTime", formula = formula1, # beta = 1.5
                  scale = scale, # scale and shape vary by group membership
                  shape = shape, transition = 0) # for survival times
  sdef <- defSurv(sdef, varname = "survTime", formula = formula2, # beta = 1.5
                  scale = scale, # scale and shape vary by group membership
                  shape = shape, transition = transition) # for survival times
  
  scale_cens <- case_when(cens == 0.5 ~ 1.5,
                          cens == 0.75 ~ 0.4,
                          cens == 0.25 ~ 10)
  
  shape_cens <- case_when(cens == 0.5 ~ 1,
                          cens == 0.75 ~ 1,
                          cens == 0.25 ~ 0.5)
  
  sdef <- defSurv(sdef, varname = "censorTime", scale = scale_cens, shape = shape_cens) # for censoring times
  
  
  
  data <- genSurv(dtAdd, sdef, timeName = "time", censorName = "censorTime", eventName = "status", keepEvents = TRUE) %>%
    dplyr::select(-c("censorTime", "survTime", "type")) %>%
    as.data.frame()
  
  round(table(data$status)/n, 2)
  
  ggplot(data, aes(x = time, fill = factor(status), group = status)) +
    geom_histogram()
  
  #return(data)
  
  round(table(data$status)/n, 2)
  
  return(data)
}

# prediction for lognormal 
S_t_lognormal <- function(t, x, scale) {
  1 - pnorm((log(t) - (x))/scale)
}



# function for integration of S for lognormal to get RMST
my_integral_lognormal <- function(x, tau, scale) {
  unlist(integrate(S_t_lognormal, lower = 0, upper = tau, x = x, scale = scale, rel.tol = .Machine$double.eps^.05))$value
}


# function for integration of S to get RMST
get_RMST <- function(i, transition = NULL, tau, beta_1, beta_2, shape, scale, data) {
  
  lp1 <- as.numeric(beta_1 %*% t(as.matrix(data[i,])))
  lp2 <- as.numeric(beta_2 %*% t(as.matrix(data[i,])))
  
  transition <- ifelse(is.null(transition), 1, transition)

  
  if(tau <= transition) {
    RMST <- unlist(integrate(S_1, lower = 0, upper = tau, lp1 = lp1, lp2 = lp2, transition = transition, 
                     tau = tau, shape = shape, scale = scale, rel.tol = .Machine$double.eps^.05))$value
  } else {
    RMST_1 <- unlist(integrate(S_1, lower = 0, upper = transition, lp1 = lp1, lp2 = lp2, transition = transition, 
                     tau = tau, shape = shape, scale = scale, rel.tol = .Machine$double.eps^.05))$value
    RMST_2 <- unlist(integrate(S_2, lower = transition, upper = tau, lp1 = lp1, lp2 = lp2, transition = transition, 
                     tau = tau, shape = shape, scale = scale, rel.tol = .Machine$double.eps^.05))$value
    
    RMST <- RMST_1 + RMST_2
  }
  
  
}

# true survival function 
S_1 <- function(t, lp1, lp2, transition, tau, shape, scale) {
  #browser()
  H_t <- (1/scale * exp(lp1) * t^(1/shape)) 
  return(exp(-H_t))
}

S_2 <- function(t, lp1, lp2, transition, tau, shape, scale) {
  #browser()
  H_t  <- (1/scale * exp(lp1) * transition^(1/shape)) +
          (1/scale * exp(lp2) * t^(1/shape)) -
          (1/scale * exp(lp2) * transition^(1/shape))
  
  return(exp(-H_t))
}




# function for integration of S to get RMST
get_RMST_cox <- function(i, tau, beta, data, model) {
  lp <- as.numeric(beta %*% t(as.matrix(data[i,])))
  unlist(integrate(S_t_cox, lower = 0, upper = tau, lp = lp, model = model, 
                   rel.tol = .Machine$double.eps^.05))$value
}


S_t_cox <- function(t, lp, model) {
  cum_basehaz <- predictCox(model, type = "cumhazard", times = t, centered = FALSE)$cumhazard
  exp(-cum_basehaz)^(exp(lp))
}


# function for integration of S to get RMST
get_RMST_cox_transition <- function(i, transition, tau, beta_1, beta_2, data, model) {
  lp1 <- as.numeric(beta_1 %*% t(as.matrix(data[i,])))
  lp2 <- as.numeric(beta_2 %*% t(as.matrix(data[i,])))
  
  if(tau < transition) {
    RMST <- unlist(integrate(S_t_cox_transition_1, lower = 0, upper = tau, lp1 = lp1, lp2 = lp2, model = model, 
                     transition = transition, rel.tol = .Machine$double.eps^.05))$value
  } else {
    
    RMST_1 <- unlist(integrate(S_t_cox_transition_1, lower = 0, upper = transition, lp1 = lp1, lp2 = lp2, model = model, 
                               transition = transition, rel.tol = .Machine$double.eps^.05))$value
    
    RMST_2 <- unlist(integrate(S_t_cox_transition_2, lower = transition, upper = tau, lp1 = lp1, lp2 = lp2, model = model, 
                               transition = transition, rel.tol = .Machine$double.eps^.05))$value
    RMST <- RMST_1 + RMST_2
  }
  
  return(RMST)
  
}


S_t_cox_transition_1 <- function(t, lp1, lp2, model, transition) {
  #browser() 
  A           <- predictCox(model, type = "cumhazard", times = t, centered = FALSE)
  cum_basehaz <- A$cumhazard[A$times <= transition & A$strata == "gr=1"]
  exp(-cum_basehaz)^(exp(lp1))
}


S_t_cox_transition_2 <- function(t, lp1, lp2, model, transition) {
  #browser()  
  A     <- predictCox(model, type = "cumhazard", times = transition, centered = FALSE)
  B     <- predictCox(model, type = "cumhazard", times = t, centered = FALSE)

  cum_basehaz_1_transition <- A$cumhazard[A$strata == "gr=1"]
  cum_basehaz_2_transition <- A$cumhazard[A$strata == "gr=2"]
  cum_basehaz_2            <- B$cumhazard[B$strata == "gr=2" & B$times > transition] 
  
  exp(-cum_basehaz_1_transition)^(exp(lp1))*
    exp(-cum_basehaz_2)^(exp(lp2)) *
    exp(-cum_basehaz_2_transition)^(exp(lp2))
}

